<?php

    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreFileCsv.php";
    
    session_start();
    controlloAccessoAdmin();
    if(!isset($_SESSION["geecomAdmin_email"]) || $_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: index.php");
        exit();
    }
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb   = new DbManager($costantiDatabase);
    $operazione = filter_input(INPUT_GET, "operazione", FILTER_SANITIZE_STRING);
    
    switch ($operazione) {
        case 'esportaTabella':
            $tabellaEsportazione = filter_input(INPUT_GET, "tabella", FILTER_SANITIZE_STRING);
            $nomeFile   = str_replace(array("geecAd","geec"),"",$tabellaEsportazione).uniqid();
            $gestoreCsv = new GestoreFileCsv("../file/csv/esportazione$nomeFile.csv", ";",false);

            $risNomiCampi = $geecomDb->elencoColonneTabella($tabellaEsportazione);

            $nomiCampi = array();
            while($campo= $risNomiCampi->fetch_assoc()) {
                $nomiCampi[count($nomiCampi)] = $campo["Field"];
            }

            $gestoreCsv->aggiungiRiga($nomiCampi); // aggiungo l'intestazione del file

            if(isset($_GET["singoloId"])) {
                $occorrenza = $geecomDb->leggiSingolaRiga($tabellaEsportazione, filter_input(INPUT_GET, "singoloId",FILTER_SANITIZE_NUMBER_INT));
                $gestoreCsv->aggiungiRiga($occorrenza);
            }
            else {
                $ris = $geecomDb->eseguiQueryLettura("SELECT * FROM $tabellaEsportazione");
                while($elemento = $ris->fetch_assoc()) {
                    $gestoreCsv->aggiungiRiga($elemento);
                }
            }
            $gestoreCsv->salva();
            header("Content-type: text/csv");
            header("Content-disposition: attachment; filename = esportazione$nomeFile.csv");
            readfile("../file/csv//esportazione$nomeFile.csv");
            break;
        case 'esportaDatabase':
            $percorso = "file/backup";
            $percorsoDump = $geecomDb->esportaDatabaseSuFile($percorso);
            $zipArchive   = new ZipArchive();
            //header("Location: $percorsoDump");
            break;
        case 'esportaFileSito':
            $nomeArchivio         = "backupFile-".date("Y-m-d-H:i").".zip";
            $percorsoCartella     = str_replace("/controller","",__DIR__);
            $percorsoDestinazione = str_replace("/controller","/file/backup/$nomeArchivio",__DIR__);
            $zipArchive = new ZipArchive();
            $fileSito = scandir($percorsoCartella);
            $zipArchive->open($percorsoDestinazione, ZipArchive::CREATE);
            foreach($fileSito as $file) {
                if($file != ".." && $file !="." && !is_dir("$percorsoCartella/$file")) {
                    $zipArchive->addFile("$percorsoCartella/$file");
                }
            }
            aggiungiFileImmagini($zipArchive,$percorsoCartella);
            aggiungiFileRisorse($zipArchive,$percorsoCartella);
            $zipArchive->close();
            header("Location: ../file/backup/$nomeArchivio");
            break;
        case 'esportaImmaginiSito':
            $nomeArchivio         = "backupImmagini-".date("Y-m-d-H:i").".zip";
            $percorsoCartella     = str_replace("/controller","",__DIR__);
            $percorsoDestinazione = str_replace("/controller","/file/backup/$nomeArchivio",__DIR__);
            $zipArchive = new ZipArchive();
            $zipArchive->open($percorsoDestinazione, ZipArchive::CREATE);
            aggiungiFileImmagini($zipArchive,$percorsoCartella);
            $zipArchive->close();
            header("Location: ../file/backup/$nomeArchivio");
            break;
        case 'esportaRisorse':
            $nomeArchivio         = "backupRisorse-".date("Y-m-d-H:i").".zip";
            $percorsoCartella     = str_replace("/controller","",__DIR__);
            $percorsoDestinazione = str_replace("/controller","/file/backup/$nomeArchivio",__DIR__);
            $zipArchive = new ZipArchive();
            $zipArchive->open($percorsoDestinazione, ZipArchive::CREATE);
            aggiungiFileRisorse($zipArchive,$percorsoCartella);
            $zipArchive->close();
            header("Location: ../file/backup/$nomeArchivio");
            break;
    }
  
    /*
     * Funzione per aggiungere all'archivio tutte le immagini contenute nella cartella
     * immagini e nelle sue sottocartelle.
     * prende in input l'archivio e il percorso base del sito a cui poi aggiunge le varie sottocartelle
     */
    function aggiungiFileImmagini($zipArchive,$percorsoCartella) {
        $arrayImmaginiAticoli = scandir("$percorsoCartella/immagini/articoli");
        foreach($arrayImmaginiAticoli as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/articoli/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/articoli/$file");
            }
        }
        
        $arrayImmaginiGallerie  = scandir("$percorsoCartella/immagini/gallerie");
        foreach($arrayImmaginiGallerie as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/gallerie/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/gallerie/$file");
            }
        }
        
        $arrayImmaginiPopup     = scandir("$percorsoCartella/immagini/popup");
        if(count($arrayImmaginiPopup)<=2) { // significa che l'array contiene solo .. e .
            $zipArchive->addEmptyDir("$percorsoCartella/immagini/popup");
        }
        foreach($arrayImmaginiPopup as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/popup/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/popup/$file");
            }
        }
        
        $arrayImmaginiSlider    = scandir("$percorsoCartella/immagini/slider");
        foreach($arrayImmaginiSlider as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/slider/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/slider/$file");
            }
        }

        $arrayImmaginiPortfolio    = scandir("$percorsoCartella/immagini/portfolio");
        foreach($arrayImmaginiPortfolio as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/portfolio/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/portfolio/$file");
            }
        }
        
        $arrayImmaginiRisorse     = scandir("$percorsoCartella/immagini/risorse");
        if(count($arrayImmaginiRisorse)<=2) { // significa che l'array contiene solo .. e .
            $zipArchive->addEmptyDir("$percorsoCartella/immagini/risorse");
        }
        foreach($arrayImmaginiRisorse as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/risorse/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/risorse/$file");
            }
        }

        $arrayAltreImmagini     = scandir("$percorsoCartella/immagini/altro");
        foreach($arrayAltreImmagini as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/immagini/altro/$file")) {
                $zipArchive->addFile("$percorsoCartella/immagini/altro/$file");
            }
        }
    }
    
    /*
     * Funzione per recuperare tutte le immagini del sito
     * prende in input il percorso base del sito a cui poi aggiunge le varie sottocartelle
     */
    function aggiungiFileTemplate($percorsoCartella) {
        $arrayImmaginiAticoli   = scandir("$percorsoCartella/immagini/articoli");
        $arrayImmaginiGallerie  = scandir("$percorsoCartella/immagini/gallerie");
        $arrayImmaginiPopup     = scandir("$percorsoCartella/immagini/popup");
        $arrayImmaginiSlider    = scandir("$percorsoCartella/immagini/slider");
        $arrayImmaginiPortfolio = scandir("$percorsoCartella/immagini/portfolio");
        $arrayImmaginiRisorse   = scandir("$percorsoCartella/immagini/risorse");
        $arrayAltreImmagini     = scandir("$percorsoCartella/immagini/altro");
        
        return array_merge($arrayImmaginiAticoli,$arrayImmaginiGallerie,$arrayImmaginiPopup,$arrayImmaginiSlider,$arrayImmaginiPortfolio,$arrayImmaginiRisorse,$arrayAltreImmagini);
    }
    
    /*
     * Funzione per all'archivio tutte le risorse contenute nella cartella risorse
     * prende in input l'archivio e il percorso base del sito a cui poi aggiunge la cartella risorse
     */
    function aggiungiFileRisorse($zipArchive, $percorsoCartella) {
        $arrayRisorse = scandir("$percorsoCartella/risorse");
        if(count($arrayRisorse)<=2) { // significa che l'array contiene solo .. e .
            $zipArchive->addEmptyDir("$percorsoCartella/risorse");
        }
        foreach($arrayRisorse as $file) {
            if($file != ".." && $file !="." && !is_dir("$percorsoCartella/risorse/$file")) {
                $zipArchive->addFile("$percorsoCartella/risorse/$file");
            }
        }
    }